function ajaxGet(url) {
  return new Promise(function(resolve, reject) {
    var xhr = new XMLHttpRequest();
    xhr.onreadystatechange = function() {
      if (xhr.readyState === 4) {
        if (xhr.status === 200) {
          resolve(xhr);
        } else {
          var err = new Error("Failed to load");
          err.xhr = xhr;
          reject(err);
        }
      }
    };
    xhr.open("GET", url, true);
    xhr.setRequestHeader("X-Streak-Web-Client", "true");
    xhr.send();
  });
}

function getInstallAppId() {
  if (localStorage.installAppId) {
    return Promise.resolve(localStorage.installAppId);
  }
  return ajaxGet(server + '/api/v1/webclient/cookies?cookieName=installAppId').then(function(xhr) {
    var response = JSON.parse(xhr.response);
    if (response.success && response.value !== undefined) {
      console.log("received installAppId from server:", response.value);
      localStorage.installAppId = response.value;
      return response.value;
    } else {
      return null;
    }
  });
}

try {
  if (safari.extension && safari.extension.setContentBlocker) {
    var contentBlocker = JSON.parse(localStorage.getItem('contentBlocker'));
    if (contentBlocker) {
      safari.extension.setContentBlocker(contentBlocker);
    }
  }
} catch(err) {
  console.error("Failed to load saved contentBlocker", err);
}

var portResponders = {
  installAppIdRequest: {
    legacyResponseName: "installAppIdResponse",
    handler: function(data) {
      return getInstallAppId().then(function(value) {
        return {
          value: value
        };
      });
    }
  },
  setImageURLblockers: {
    handler: function(data) {
      if (!safari.extension || !safari.extension.setContentBlocker) {
        return false;
      }

      var blockers = data.safariGlobalBlockers.map(function(regexData) {
        return {
          "action": {
            "type": "block"
          },
          "trigger": {
            "url-filter": regexData.source,
            "resource-type": ["image"],
            "if-domain": ["*google.com", "*googleusercontent.com", "*mailfoogae.appspot.com"]
          }
        };
      });
      var whitelist = data.safariGlobalWhitelist.map(function(regexData) {
        return {
          "action": {
            "type": "ignore-previous-rules"
          },
          "trigger": {
            "url-filter": regexData.source,
            "resource-type": ["image"],
            "if-domain": ["*google.com", "*googleusercontent.com", "*mailfoogae.appspot.com"]
          }
        };
      });
      var contentBlocker = blockers.concat(whitelist);
      safari.extension.setContentBlocker(contentBlocker);
      localStorage.setItem('contentBlocker', JSON.stringify(contentBlocker));
      return true;
    }
  },
  "default": {
    handler: function() {
      throw new Error("Unknown op");
    }
  }
};

function respondToMessage(event) {
  if (event.name !== "streakMessage") {
    return;
  }

  var responder = (Object.prototype.hasOwnProperty.call(portResponders, event.message.name)) ?
    event.message.name : 'default';
  Promise.resolve().then(function() {
    return portResponders[responder].handler(event.message.data);
  }).then(function(response) {
    var message = {
      id: event.message.id,
      payload: response
    };
    if (portResponders[responder].legacyResponseName) {
      // Eventually the combined.js code should just find the response by id,
      // instead of relying on this.
      message.name = portResponders[responder].legacyResponseName;
    }
    event.target.page.dispatchMessage("streakReturnMessage", message);
  }, function(error) {
    console.error("Error in portResponder:", error);
    event.target.page.dispatchMessage("streakReturnMessage", {
      id: event.message.id,
      error: true,
      message: error && error.message,
      stack: error && error.stack
    });
  });
}

safari.application.addEventListener("message", respondToMessage, false);

// taken from http://hoyois.github.com/safariextensions/universalextension/#script_loader
function addContentScripts(scripts, whitelist, blacklist, runAtEnd) {
  function loadScript() {
    if (scripts.length === 0) return;
    var script = scripts.shift();
    ajaxGet(script).then(function(xhr) {
      safari.extension.addContentScript(xhr.responseText, whitelist, blacklist, runAtEnd);
      loadScript(); //recursive iterate
    }, function(err) {
      console.error(err);
      scripts.unshift(script); //let's get the script back in
      setTimeout(loadScript, 500); //now we try again
    });
  }

  loadScript();
}

//adding detection to Streak homepage
addContentScripts([server + combinedPath + "safari/detect.js"], ["http://*.streak.com/*", "https://*.streak.com/*", "http://*.mailfoogae.appspot.com/*", "http://mailfoogae.appspot.com/*", "https://mailfoogae.appspot.com/*"], null, true);

//adding content scripts to Gmail
addContentScripts([server + combinedPath + "safari/app.js"], ["http://mail.google.com/*", "https://mail.google.com/*"], null, true);
